from django.urls import path
from .views import project_list, add_project, edit_project, delete_project, project_dashboard, project_summary, project_ledger
from .views import project_income_statement, project_purchases, project_document_upload, delete_project_document

urlpatterns = [
    path("projects/", project_list, name="project_list"),
    path("projects/add/", add_project, name="add_project"),
    path("projects/edit/<int:pk>/", edit_project, name="edit_project"),
    path("projects/delete/<int:pk>/", delete_project, name="delete_project"),
    path('projects/<int:project_id>/dashboard/', project_dashboard, name='project_dashboard'),
    path('projects/<int:project_id>/summary/', project_summary, name='project_summary'),
    path('projects/project/<int:project_id>/ledger/', project_ledger, name='project_ledger'),
    path('projects/project/<int:project_id>/income-statement/', project_income_statement, name='project_income_statement'),
    path('projects/project/<int:project_id>/project_purchases/', project_purchases, name='project_purchases'),
    path('projects/<int:project_id>/upload_document/', project_document_upload, name='project_document_upload'),
    path('projects/documents/<int:document_id>/delete/', delete_project_document, name='delete_project_document'),
    
    
]