from django import forms
from django.forms import inlineformset_factory
from .models import Project, ProjectDocument

class ProjectForm(forms.ModelForm):
    class Meta:
        model = Project
        fields = '__all__'
        widgets = {
            'project_code': forms.TextInput(attrs={'class': 'form-control'}),
            'project_title': forms.TextInput(attrs={'class': 'form-control'}),
            'project_description': forms.Textarea(attrs={'class': 'form-control'}),
            'awarding_department': forms.TextInput(attrs={'class': 'form-control'}),
            'site_location': forms.TextInput(attrs={'class': 'form-control'}),
            'commencement_date': forms.DateInput(attrs={'type': 'date', 'class': 'form-control'}),
            'completion_date': forms.DateInput(attrs={'type': 'date', 'class': 'form-control'}),
            'loi_date': forms.DateInput(attrs={'type': 'date', 'class': 'form-control'}),
            'work_award_amount': forms.NumberInput(attrs={'class': 'form-control work_award_amount-input', 'placeholder': '0.00'}),
            'percent_estimate': forms.NumberInput(attrs={'class': 'form-control percent_estimate-input', 'placeholder': '0.00'}),
        }


class ProjectDocumentForm(forms.ModelForm):
    class Meta:
        model = ProjectDocument
        fields = ['document_type', 'document', 'notes']  # Remove 'Projects' from here
        widgets = {
            'document_type': forms.Select(attrs={'class': 'form-control'}),
            'document': forms.ClearableFileInput(attrs={'class': 'form-control'}),
            'notes': forms.Textarea(attrs={'class': 'form-control', 'rows': 2}),
        }

