from django.contrib import admin
from .models import ProductCategory, Product, Warehouse, StockMovement, MaterialType, MaterialConsumption, MaterialConsumptionItem
# Register your models here.

admin.site.register(MaterialConsumption)
admin.site.register(MaterialConsumptionItem)


@admin.register(ProductCategory)
class ProductCategoryAdmin(admin.ModelAdmin):
    list_display = ('name',)
    search_fields = ('name',)
    
@admin.register(MaterialType)
class MaterialTypeAdmin(admin.ModelAdmin):
    list_display = ('name', 'description')
    list_filter = ('name',)
    search_fields = ('name',)
    ordering = ('name',)

@admin.register(Warehouse)
class WarehouseAdmin(admin.ModelAdmin):
    list_display = ('code', 'name', 'location', 'is_active')
    search_fields = ('code', 'name', 'location')

@admin.register(StockMovement)
class StockMovementAdmin(admin.ModelAdmin):
    list_display = ('product', 'warehouse', 'movement_type', 'quantity', 
                   'purchase_price', 'sale_price', 'date')
    list_filter = ('movement_type', 'warehouse', 'date')
    search_fields = ('product__name', 'product__code', 'reference')
    date_hierarchy = 'date'
    fieldsets = (
        (None, {
            'fields': ('product', 'warehouse', 'movement_type')
        }),
        ('Pricing', {
            'fields': ('purchase_price', 'sale_price'),
            'classes': ('collapse',)
        }),
        ('Details', {
            'fields': ('quantity', 'reference', 'notes')
        })
    )





